/*

 Main Script of the Sphere Community Game
 
 18 apr 2007 - VvB inital version, Vincent van Beveren
 17 oct 2007 - FBn Changed the Intro. Functionally identical, but now runs with Plethora.
 
 */

RequireScript('logger.js');

var Game = new Object();        // global 'Game' object for settings

Game.log = new Logger('scg.log', Logger.DEBUG);
Game.log.info('Loading Sphere Community game!');

// Redefine the original require script, so they all print that they are initializing (we'll restore the original later on).
RequireScript_ = RequireScript;
RequireScript = function(script){
	GetSystemFont().drawText(20,10, " Loading... "+script); FlipScreen();
	Game.log.info('Loading '+script);
	RequireScript_(script);
	Game.log.info('Loaded '+script);
}

RequireScript("initialize.js");  // init global resources including scripts
RequireScript = RequireScript_; // Restore original RequireScript() function.

Game.log.info('Sphere Community game Loaded.');


// ====== main game function ====== //
function game() {
	Game.log.info('Main game function entered');

	var option = title();
	//var option = 1;

	if (option == 0) {
		loopGame();	// start main game loop
	} else if (option == 1) {
		Game.lithonite.AttachAll("Daniel","Daniel", Game.Keys.talk);
		MapChange.start( 60, "kamajs/kamajs_village_return.rmp", "center", undefined, 'fromblack');
		//MapChange.start( 60, "kamajs/kamajs_village_return_southof.rmp", "center2");
	} else if (option == 2) {
		Game.lithonite.AttachAll("Daniel","Daniel", Game.Keys.talk);
		MapChange.start( 60, "kamajs/kamajs_mine_shaft_entrance.rmp", "Tracks!", "", 'fromblack');
	} else if (option == 3) {
		Game.lithonite.AttachAll("Daniel","Daniel", Game.Keys.talk);
		MapChange.start( 60, "kamajs/kamajs_mine_shaft_elevator_down.rmp", "floor_1", "Going down", 'fromblack');
	} else if (option == 4) {
		Exit;
	}
}

// ====== mani game loop ======
function loopGame() {
	Game.lithonite.AttachAll(); // Attach Input and Camera
	SetTalkActivationKey( Game.Keys.talk );
	// The parameters for the following function are:
	// TeleporthicaEngine.prototype.start = function(fps,rmpfilename,warppoint,titlemsg,fade)
	MapChange.start( 60, "realworld/daniels_room.rmp", 'enterthesphere', "Daniel\\'s Room", 'fromblack' );
}

function loadSavedGame(){
}

// ====== show title screen ======

function title() {

	// Load some resources for our intro
  	var snd = LoadSound('music/theme.it');
	snd.play(false);
	var img = LoadImage('title/logo.png');
	var bg  = LoadImage('title/BG.png');

	// Start a cutscene
  	nQ( { scenelet: 'FadeFromColor',
		msecs: 3000,
		color: CreateColor(0,0,0, 255),
		bgimage: bg
	} );

	// Delay the eventqueue 1000 milliseconds
	dQ(1000);

	nQ( { scenelet: 'FadeToColor',
                msecs: 2000,
                color: CreateColor(255,255,255, 0),
		bgimage: bg,
                image: img,
		x1: (GetScreenWidth() - img.width) >>1,
		y1: 0,
		x2: (GetScreenWidth() - img.width) >>1,
		y2: (GetScreenHeight() - img.height) >>1,
		translucency:255,

        } );

	dQ(1000);

	nQ( { scenelet: 'FadeFromColor',
		msecs: 2000,
		color: CreateColor(255,255,255, 125),
		bgimage: bg,
		image: img,
		x1: (GetScreenWidth() - img.width) >>1,
		y1: (GetScreenHeight() - img.height) >>1,
		translucency:125,
	} );

	// Play all queued events, at about 60 fps, and it can be cancelled by pressing any key
	// autoplay() returns true when it has been cancelled
	Game.EventQueue.autoplay('SplashScreen', 60, true);

	// Now set the background ready for Menu() to grab the image ...
	bg.blit(0, 0);
	img.blitMask(GetScreenWidth() / 2 - img.width / 2, (GetScreenHeight() - img.height) / 2, CreateColor(255,255,255, 125) );

	// Run the menu (Menu.js)
	var result = Game.initialMenu.Menu();

	// Stop the music, and return the chosen option
	snd.stop(); 
	return result;
}

